#/bin/bash

#LSOF=$(lsof -i -n | egrep '\<sshd\>' | grep IPv4 | grep root | grep '(LISTEN)' | grep '127.0.0.1' | egrep '22[0-9][0-9][0-9]'|  awk '{print $9}' | cut -d ':' -f 2 | cut -d '-' -f 1)
## Before Change
LSOF=$(lsof -i -n | egrep '\<sshd\>' | grep IPv4 | grep root | grep '(LISTEN)' | grep '*' | egrep ':22[0-9][0-9][0-9]' | grep -v "22020" |  awk '{print $9}' | cut -d ':' -f 2 | cut -d '-' -f 1)
LSOF=$(echo $LSOF)
LSOF=$(echo ${LSOF// /,})
#echo -e $LSOF
IFS=',' read -r -a ports <<< "$LSOF"
SRC=0
#echo $LSOF
#echo "${array[0]}"

# get index + val :
#for index in "${!array[@]}"
#do
#    echo "$index ${array[index]}"
#done
        #22493 | 3b82fd1dbb1aea7889d0aadd24385984 | thueyts | rpi-router-sfr

if [[ $1 == 'list' ]]; then
        /root/tunlist.sh $$
fi

if [[ $1 == '' ]]; then
        echo -ne "Tunnels:\n------+----------------------------------+------+---------------+----------------\n"
        echo -ne "Port  | podUid\t\t\t\t | Stat | Local. \t| Device Name\n"
        echo -ne "------+----------------------------------+------+---------------+----------------\n"
        #Port  | podUid                          | Stat | Local.        | Device Name
        #------+---------------------------------+------+---------------+----------------
fi

for port in "${ports[@]}"
do
        __apiCall='http://stateless.hive.hrig.tech/api/tunnel/readOne.php?slot='$port'&status=*'
        __apiReturn=$(curl -s $__apiCall)
#       echo '['$__apiReturn']'
        __podUID=$(echo $__apiReturn | jq -r .usedBy)
#       echo '{'$__podUID'}'
        __status=$(echo $__apiReturn | jq -r .status)

        if [[ $__podUID == '' ]]; then
                __podUID='\t\t\t\t'
                __commonName='Unknown'
                __commonNameLocation='Unknown'
        else
                __commonNames=$(cat /etc/stateless.conf | grep $__podUID | awk '{print$3}')
                __commonName=$(echo $__commonNames | cut -d '.' -f 1)
                __commonNameLocation=$(echo $__commonNames | cut -d '.' -f 2)
        fi

        if [[ $1 == '' ]]; then
                echo -ne "$port | "$__podUID" | "$__status" | "$__commonNameLocation" \t| "$__commonName"\n"
        else
                if [[ $1 == "port" ]]; then
                        if [[ $2 == '' ]]; then
                                echo 'Error: No port specified!'
                                break
                        else
                                ssh-keygen -f "/root/.ssh/known_hosts" -R [127.0.0.1]:$2 2>/dev/null
                                ssh 127.0.0.1 -p $2
                                break
                        fi
                else
                        if [[ $1 == $__commonName ]]; then
                                echo $__commonName" (" $port ") FOUND!"
                                ssh-keygen -f "/root/.ssh/known_hosts" -R [127.0.0.1]:$port
                                ssh 127.0.0.1 -p $port
                                break
                        else
                                SRC=1
                        fi
                fi
        fi
#       echo '"'$__commonName'"'
done

if [[ $SRC -eq 1 ]]; then
        echo -ne "Host not found in list!\n\n"
        /root/tunlist.sh
fi

