#!/bin/bash

ENDP_IP='8.8.8.8'
FAILCOUNT_PATH='/tmp/.wifiWatchD.failcount'

if [ ! -f $FAILCOUNT_PATH ]; then
    echo 0 > $FAILCOUNT_PATH
fi

WIFI_IP=$(/sbin/ifconfig en1 inet | grep -i inet | /usr/bin/awk '{print $2}')
GG_PING=$(/sbin/ping -S $WIFI_IP $ENDP_IP -c 3 -W 1000 -i 0.25 2>/dev/null | grep "3 packets received" -c)
EN_STAT=$(/sbin/ifconfig | grep en1 | grep inet -c)
MAX_FAILCOUNT=3
FAILCOUNT=$(cat $FAILCOUNT_PATH)

## Func
date=$(date)

#echo "Failcount "$FAILCOUNT

function logger () {
	echo -ne $date'\t' >> /Users/admin/usr/vlu/logs/wifi_watchdog.log
	echo -e $1 >> /Users/admin/usr/vlu/logs/wifi_watchdog.log
}

function FDJ_AutoConnectCaptive () {
	logger "Starting FDJ AutoConnect"
	/usr/bin/open -a "Google Chrome" 'https://controller.access.network/107/portal/'
	sleep 30
	killall "Google Chrome"
	echo 0 > $FAILCOUNT_PATH
}

function bringUpDownWLAN () {
	if [[ $1 == "up" ]]; then param='on'; else param='off'; fi

	#echo 'request='$param
	/usr/sbin/networksetup -setairportpower en1 $param
}

## Main

if [[ $FAILCOUNT -ge $MAX_FAILCOUNT ]]; then
	FDJ_AutoConnectCaptive
fi

if [[ $WIFI_IP == '' ]]; then
	logger "IP is void..."

	if [[ $EN_STAT -lt 1 ]]; then
		bringUpDownWLAN up
		sleep 5
	fi

	/usr/sbin/networksetup -setairportnetwork en1 GUEST
	FDJ_AutoConnectCaptive
else
	logger "We do have IP! "$WIFI_IP
	if [ $GG_PING -lt 1 ]; then
		FAILCOUNT=$(cat $FAILCOUNT_PATH)
		FAILCOUNT=$((FAILCOUNT+1))
		echo $FAILCOUNT > $FAILCOUNT_PATH

		logger "Unable to ping Google DNS A ("$FAILCOUNT"/"$MAX_FAILCOUNT")"
	else
        	logger "Iface is up, google is pinging..."
		echo 0 > $FAILCOUNT_PATH
	fi
fi
